﻿var exportResponses = {
    context: $(".v-exportResponses"),
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        exportResponses.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-extractionTable", exportResponses.context).a4datatable({
            ajaxAction: a4.getSurveyAction("GetExportations", "Analyze"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id", "Type": "numeric" },
                { "Data": "Message", "Tooltip": true },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Class": "v-name" },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum" },
                { "Name": "Type", "Title": resources.Type, "Data": "Type" },
                { "Name": "Description", "Title": resources.Description, "Data": "Description", "Class": "v-text" },
                { "Name": "CreationDate", "Title": resources.CreationDate, "Data": "CreationDate", "Visible": false },
                { "Name": "LastRun", "Title": resources.LastRun, "Data": "LastRun", "type": "datetime", "DefaultValue": resources.NotAvailable },
                { "Name": "NextRun", "Title": resources.NextRun, "Data": "NextRun", "type": "datetime", "DefaultValue": resources.NotScheduled }
            ],
            localizableTexts: { "Search": resources.SearchExportResponses },
            defaultSorting: { Column: "CreationDate", Ascending: false },
            stateKey: "ExportResponses",
            autoUpdate: true,
            toolBarItems: exportResponses.getToolBarItems(),
            contextMenuItems: exportResponses.getContextMenuItems(),           
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    exportResponses.deleteItems(ids);
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "download":
                        exportResponses.downloadFile(row.Id);
                        break;
                    case "executenow":
                        exportResponses.updateTaskStatus(row.Id, 1);
                        break;
                    case "stop":
                        exportResponses.updateTaskStatus(row.Id, 3);
                        break;
                    case "editSchedule":
                        modalDialog.showWindow(a4.getAction("ScheduleEditor", "Shared", "Home", { surveyId: a4.getSurveyId(), exportId: row.Id }), 600, 850, { afterClose: function () { focusFirstField: false, exportResponses.refreshDataTable(); } });
                        break;
                    case "edit":
                        exportResponses.editItem(row, "false");
                        break;
                    case "copy":
                        exportResponses.editItem(row, "true");
                        break;
                    case "delete":
                        exportResponses.deleteItems(row.Id);
                        break;
                    case "history":
                        modalDialog.showWindow(a4.getAction("TaskHistory", "Shared", "Home", { extractionId: row.Id, name: row.Name }), 600, 950);
                        break;
                }
            }
        });
    },
    downloadFile: function (id) {
        var link = a4.getSurveyAction("DownloadExportation", "Analyze", { taskId: id });
        a4.showBusyBox();

        a4.callServerMethod(link, {},
        function (result) {
            a4.hideBusyBox();
            if (result.success)
                window.location = a4.getSurveyAction("GetExportationFile", "Analyze", { filename: result.filename, type: result.type });
            else
                a4.showErrorMessage(result.message);
        },
        function (error) {
            a4.onAjaxPageMethodError(error);
        });
    },
    updateTaskStatus: function (id, status) {
        a4.callServerMethod(a4.getSurveyAction("UpdateExportationStatus", "Analyze"), { id: id, status: status },
        function (result) {
            exportResponses.refreshDataTable();
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteQuestionResources, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteExportations", "Analyze"), { itemIds: items },
                function (result) {
                    exportResponses.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    editItem: function (item, copy) {
        window.location = a4.getSurveyAction("ExportResponsesWizard", "Analyze", { id: item.Id, format: item.Type, copyTask: copy });
    },
    getContextMenuItems: function () {
        return [
            { "Action": "editSchedule", "Label": resources.EditSchedule, "DisplayCondition": function (data) { return data.Status != 'Running'; } },
            { "Divider": true },
            { "Action": "copy", "Label": resources.Copy },
            { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Status != 'Running'; }},
            { "Action": "edit", "Label": resources.Properties, "DisplayCondition": function (data) { return data.Status != 'Running'; } },
            { "Divider": true },
            { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return _.contains(['Running', 'Pending'], data.Status); }},
            { "Action": "executenow", "Label": resources.ExecuteNow, "DisplayCondition": function (data) { return data.Status != 'Running'; } },
            { "Action": "history", "Label": resources.History },
            { "Divider": true },
            {
                "Action": "download", "Label": resources.DownloadFile,
                "DisplayCondition": function (data) {
                    return _.contains(['Completed', 'Stopped', 'Pending'], data.Status);
                }
            }
        ];
    },
    getToolBarItems: function () {
        return [{ "Action": "delete", "Label": resources.Delete }];
    }
}

$(document).ready(function () {
    if (exportResponses.context.length > 0) {
        exportResponses.initializeDataTable();
    }
});